---
title: Filter your AutoRAG search by file name · Changelog
description: You can now filter AutoRAG search queries by file name, allowing
  you to control which files can be retrieved for a given query.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-19-autorag-filename-filter/
  md: https://developers.cloudflare.com/changelog/2025-06-19-autorag-filename-filter/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Filter your AutoRAG search by file name

Jun 19, 2025

[AI Search](https://developers.cloudflare.com/ai-search/)

In [AutoRAG](https://developers.cloudflare.com/ai-search/), you can now [filter](https://developers.cloudflare.com/ai-search/configuration/metadata/) by an object's file name using the `filename` attribute, giving you more control over which files are searched for a given query.

This is useful when your application has already determined which files should be searched. For example, you might query a PostgreSQL database to get a list of files a user has access to based on their permissions, and then use that list to limit what AutoRAG retrieves.

For example, your search query may look like:

```js
const response = await env.AI.autorag("my-autorag").search({
  query: "what is the project deadline?",
  filters: {
    type: "eq",
    key: "filename",
    value: "project-alpha-roadmap.md",
  },
});
```

This allows you to connect your application logic with AutoRAG's retrieval process, making it easy to control what gets searched without needing to reindex or modify your data.

Learn more in AutoRAG's [metadata filtering documentation](https://developers.cloudflare.com/ai-search/configuration/metadata/).
