---
title: Error 1013 · Cloudflare Support docs
description: This error indicates a mismatch between the HTTP hostname and the
  TLS SNI hostname.
lastUpdated: 2025-05-14T13:30:35.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1013/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1013/index.md
---

## Error 1013: HTTP hostname and TLS SNI hostname mismatch

This error indicates a mismatch between the HTTP hostname and the TLS SNI hostname.

### Common cause

The hostname sent by the client or browser via Server Name Indication (SNI) does not match the request host header.

### Resolution

Error `1013` is commonly caused by the following:

* Your local browser setting the incorrect SNI host header, or
* A network proxying SSL traffic caused a mismatch between SNI and the Host header of the request.

Test for an SNI mismatch via an online tool, such as [SSL Shopper](https://www.sslshopper.com/ssl-checker.html).

Provide Cloudflare Support the following information:

* A [HAR file](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/) captured while duplicating the error.
